<?php
/**
 * /checkout/save_email.php
 * Accepts JSON: {checkout_id, email, plan_code?, plan_name?, amount?, currency?, source?}
 * Saves (or upserts) a row into `checkout_leads`.
 * Responds with JSON: {"ok":true} or {"ok":false,"error":"..."}
 */

header('Content-Type: application/json; charset=utf-8');
// If you’ll ever call this from a different origin, uncomment CORS lines:
// header('Access-Control-Allow-Origin: https://raidlinestudio.com');
// header('Access-Control-Allow-Headers: Content-Type');
// if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') { http_response_code(204); exit; }

try {
  // ---- Read & validate input ----
  $raw = file_get_contents('php://input');
  if ($raw === false) { throw new RuntimeException('no_input'); }
  $in = json_decode($raw, true);
  if (!is_array($in)) { http_response_code(400); echo json_encode(['ok'=>false,'error'=>'invalid_json']); exit; }

  $checkout_id = trim((string)($in['checkout_id'] ?? ''));
  $email       = trim((string)($in['email'] ?? ''));
  $plan_code   = trim((string)($in['plan_code'] ?? ''));
  $plan_name   = trim((string)($in['plan_name'] ?? ''));
  $amount      = $in['amount'] ?? null;         // numeric or null
  $currency    = strtoupper(trim((string)($in['currency'] ?? '')));
  $source      = trim((string)($in['source'] ?? 'unknown'));

  if ($checkout_id === '' || !filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>'invalid_input']);
    exit;
  }

  // Soft length guards (avoid oversized payloads)
  if (strlen($checkout_id) > 64)  $checkout_id = substr($checkout_id, 0, 64);
  if (strlen($email) > 190)       $email       = substr($email, 0, 190);
  if (strlen($plan_code) > 64)    $plan_code   = substr($plan_code, 0, 64);
  if (strlen($plan_name) > 190)   $plan_name   = substr($plan_name, 0, 190);
  if (strlen($currency) > 8)      $currency    = substr($currency, 0, 8);
  if (strlen($source) > 32)       $source      = substr($source, 0, 32);

  // Normalize amount
  if (!is_null($amount)) {
    if (!is_numeric($amount)) $amount = null;
    else $amount = round((float)$amount, 2);
  }

  // ---- DB connection (your credentials) ----
  $host     = "localhost";
  $dbname   = "tvnuzqfp_LoginPluxi";
  $username = "tvnuzqfp_YoussefDataLogin";
  $password = "N67M5aLYQHM}";

  $pdo = new PDO(
    "mysql:host=$host;dbname=$dbname;charset=utf8mb4",
    $username,
    $password,
    [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
      PDO::ATTR_EMULATE_PREPARES => false,
    ]
  );

  // ---- Ensure table exists ----
  $pdo->exec("
    CREATE TABLE IF NOT EXISTS checkout_leads (
      id INT AUTO_INCREMENT PRIMARY KEY,
      checkout_id VARCHAR(64) NOT NULL,
      email VARCHAR(190) NOT NULL,
      plan_code VARCHAR(64) DEFAULT NULL,
      plan_name VARCHAR(190) DEFAULT NULL,
      amount DECIMAL(10,2) DEFAULT NULL,
      currency VARCHAR(8) DEFAULT NULL,
      status VARCHAR(32) DEFAULT 'lead',  -- 'lead' | 'paid'
      source VARCHAR(32) DEFAULT NULL,    -- e.g. blur | success
      ip VARCHAR(64) DEFAULT NULL,
      ua VARCHAR(255) DEFAULT NULL,
      created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
      UNIQUE KEY uniq_checkout_email (checkout_id, email)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
  ");

  // ---- Insert or update ----
  $stmt = $pdo->prepare("
    INSERT INTO checkout_leads
      (checkout_id, email, plan_code, plan_name, amount, currency, status, source, ip, ua)
    VALUES
      (:cid, :email, :pcode, :pname, :amt, :cur, 'lead', :src, :ip, :ua)
    ON DUPLICATE KEY UPDATE
      plan_code = VALUES(plan_code),
      plan_name = VALUES(plan_name),
      amount    = VALUES(amount),
      currency  = VALUES(currency),
      source    = VALUES(source),
      ip        = VALUES(ip),
      ua        = VALUES(ua)
  ");

  $stmt->execute([
    ':cid'   => $checkout_id,
    ':email' => $email,
    ':pcode' => ($plan_code !== '') ? $plan_code : null,
    ':pname' => ($plan_name !== '') ? $plan_name : null,
    ':amt'   => $amount,
    ':cur'   => ($currency !== '') ? $currency : null,
    ':src'   => ($source !== '') ? $source : null,
    ':ip'    => $_SERVER['REMOTE_ADDR'] ?? null,
    ':ua'    => substr($_SERVER['HTTP_USER_AGENT'] ?? '', 0, 250),
  ]);

  echo json_encode(['ok'=>true]);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()]);
}
